﻿<%@ Page Language="C#" Title = "" AutoEventWireup="true" CodeFile="Referrals.aspx.cs" Inherits="Referrals" MasterPageFile = "~/Registry.master"  %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID = "ContentPlaceHolder" Runat="Server" >

    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
    
    <div class="breadcrumb">
          
        <asp:FormView ID="FormViewBreadCrumb" runat="server" DataSourceID="ObjectDataSourceEFRReferralsStatus">
            <ItemTemplate>
              <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text='<%# "My Tasks > Referrals > " + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NAME")), false) %>'  />
             
            </ItemTemplate>
        </asp:FormView>
         
    </div>    
     
   <br />
   <div class = "excludeSaveWarnings">
   <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <br />
    </div>
    <asp:GridView ID = "GridViewEFRReferrals" runat = "server" DataSourceID = "ObjectDataSourceEFRReferrals" AutoGenerateColumns = "false" OnRowCommand = "ReferralView_RowCommand" 
    AllowPaging="True" PageSize="20" DataKeyNames = "ReferralId" AllowSorting="true">
       <EmptyDataTemplate>
            No referrals exist in this status
       </EmptyDataTemplate> 
        
        <Columns>
        
            <asp:TemplateField HeaderText = "Referral Number" SortExpression = "REFERRAL_ID">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelReferralID" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralId")), false) %>'></asp:Label> 
                
                </ItemTemplate> 
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Patient Name" SortExpression="PATIENT.LAST_NAME">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientName")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Site Number" SortExpression="STD_INSTITUTION.STATIONNUMBER">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("StationNumber")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
           
            <asp:TemplateField HeaderText="Facility" SortExpression="STD_INSTITUTION.NAME">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("InstitutionName")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Referral Date" SortExpression="REFERRAL_DATE">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientReferralDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralDate", "{0:d}")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
                             
            <asp:TemplateField HeaderText="Status" SortExpression="STD_REFERRALST.NAME">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientReferralDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralStatus")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
        </Columns>
    </asp:GridView>            
    <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
    <asp:ObjectDataSource ID="ObjectDataSourceEFRReferrals" runat="server" 
            SelectMethod="SelectByStatus" 
            SelectCountMethod="SelectByStatusCount"
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True" 
            TypeName="VeteransAffairs.Registries.BusinessManager.ReferralManager">

   <SelectParameters>
        <asp:ControlParameter Name = "searchValue" ControlID = "TextBoxSearchCriteria" DefaultValue = "" />    
        <asp:QueryStringParameter Name = "id" QueryStringField = "statusId" DefaultValue="0" /> 
   </SelectParameters>         
   </asp:ObjectDataSource>
   
   
   <asp:ObjectDataSource ID = "ObjectDataSourceEFRReferralsStatus" runat = "server" SelectMethod = "GetNameByStatusId" 
   TypeName = "VeteransAffairs.Registries.BusinessManager.ReferralManager">
        <SelectParameters>
        <asp:QueryStringParameter Name = "id" QueryStringField = "statusId" DefaultValue="0" /> 
   </SelectParameters>
   
   </asp:ObjectDataSource> 
                    
</asp:Content> 